<?php
	error_reporting(E_ALL);
	ini_set('display_errors', '1');
	$root=$_SERVER['WEB_ROOT']=str_replace($_SERVER['SCRIPT_NAME'],"",$_SERVER['SCRIPT_FILENAME']);
	$host = $_SERVER['HTTP_HOST'];
	$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http';
	require_once("$root/assets/setup/library.php");

	function back($script=null) {
		global $host,$protocol;
		if(!$script) $script=$_SERVER['SCRIPT_NAME'];
		header("Location: $protocol://$host$script");
		exit;
	}

	function clearDir($dir) {
		array_map('unlink', array_filter(glob("$dir/*")));
	}
#print_r($_GET);
	$action=@$_GET['action'];

	//	Preliminary Setup Info
		if(!is_dir("$root/database/")) mkdir("$root/database/");

		$dsn="sqlite:$root/database/australia.sqlite";
		$sqlite = new PDO($dsn);

		if(!$sqlite->query("SELECT count(*) FROM sqlite_master WHERE type='table' AND name='info'")->fetchColumn()) {
			$sqlite->exec('CREATE TABLE info (server VARCHAR(8) NOT NULL, database VARCHAR(8) NOT NULL, password VARCHAR(60) NOT NULL)');
			$action='init';
		}

		if($action=='info') {
			$sqlite->exec("DELETE FROM info; DELETE FROM SQLITE_SEQUENCE WHERE name='info'");
			$sql='INSERT INTO info(server,database,password) VALUES(?,?,?)';
			$pds=$sqlite->prepare($sql);
			$pds->execute([$_GET['server'],$_GET['database'],$_GET['password']]);
			header("Location: $protocol://$host/assets/setup");
			exit;
		}

		$info=$sqlite->query('SELECT server,database,password FROM info')->fetch(PDO::FETCH_ASSOC);

		if($action=='init') $info=null;
	$database=$info['database'];

	switch($database) {
		case 'sqlite':
			$dsn="sqlite:$root/database/australia.sqlite";

			try {
				$pdo = new PDO($dsn);
			} catch(PDOException $e) {
				die ($e->getMessage());
			}
			$pdo->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
			break;
		case 'mysql':
#		default:
			define('USER','root');
			define('PASSWORD',$info['password']);
			$dsn='mysql:host=localhost;charset=utf8mb4';

			try {
				$pdo = new PDO($dsn,USER,PASSWORD);
			} catch(PDOException $e) {
				die ($e->getMessage());		//	Exit, displaying the error message
			}
			$pdo->exec('SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE;');
			$pdo->exec('SET SESSION sql_mode = \'ANSI\';');
			$pdo->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
	}

	if($action && $action!='init') {
		if($action!='australia') $pdo->exec('USE australia');

		switch($action) {
			case 'australia':
			case 'imagescreate':
				$pdo->exec(file_get_contents("$database/$action.sql"));
				break;
			case 'import-images':
				$options = FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES;
				$file = file('images.csv', $options);
				array_shift($file);
				foreach($file as $line) {
					$line = trim($line);
					if(!$line || $line[0] == '#') continue;
					$data = str_getcsv($line);
					$data[]=$data[0];
					//	Normalise Description
						$data[2] = str_replace("\r",'',$data[2]);	//	remove CR
						$data[2] = str_replace('\n',"\n",$data[2]);	//	convert '\n'
					//	Add to the Database
						$pdoStatement=$pdo->prepare('INSERT INTO images(name,title,description,src) values(?,?,?,?)');
						$pdoStatement->execute($data);
						$id = $pdo->lastInsertId();

						$info=pathinfo($data[0]);
						$src=sprintf('%s-%06s.%s',$info['filename'],$id,$info['extension']);
						$pdoStatement=$pdo->prepare('UPDATE images SET src=? WHERE id=?');
						$data = [$src,$id];
						$pdoStatement->execute($data);

				}
				break;
			case 'reset-images':
				$sql = $database == 'sqlite' ? "DELETE FROM info; DELETE FROM SQLITE_SEQUENCE WHERE name='info'" : 'TRUNCATE TABLE images';
				$pdo->exec($sql);
				clearDir("$root/images/originals");
				clearDir("$root/images/previews");
				clearDir("$root/images/thumbnails");
				clearDir("$root/images/icons");
				break;
			case 'copy-images':
				$sql='SELECT name,src FROM images';
				foreach($pdo->query($sql) as $row) {
					list($name,$src)=$row;
					copy("$root/assets/animals/$name","$root/images/originals/$src");
					makeThumbnail("$root/images/originals/$src","$root/images/previews/$src",'320x240');
					makeThumbnail("$root/images/originals/$src","$root/images/thumbnails/$src",'160x120');
					makeThumbnail("$root/images/originals/$src","$root/images/icons/$src",'40x30');
				}
				break;
			case 'users':
				$pdo->exec(file_get_contents("$database/$action.sql"));
				break;
			case 'user':
				$sql='INSERT INTO users(email,familyname,givenname,hash,admin) VALUES (?,?,?,?,?)';
				$email=$_GET['email'];
				$password=$_GET['password'];
				$password=password_hash($password,PASSWORD_DEFAULT);
				$data=[$email,$_GET['familyname'],$_GET['givenname'],$password,1];
				$pdo->prepare($sql)->execute($data);
				break;
			case 'blogcreate':
				$pdo->exec(file_get_contents("$database/$action.sql"));
				break;
			case 'import-blog':
				$options = FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES;
				$file = file('blog.csv', $options);
				array_shift($file);
				foreach($file as $line) {
					$line = trim($line);
					if(!$line || $line[0] == '#') continue;
					$data = str_getcsv($line);
					//	Normalise Article
						$data[2] = str_replace("\r",'',$data[2]);	//	remove CR
						$data[2] = str_replace('\n',"\n",$data[2]);	//	convert '\n'
					//	Add to the Database
						$pdoStatement=$pdo->prepare('INSERT INTO blog(title,precis,article,created,updated) values(?,?,?,?,?)');
						$pdoStatement->execute($data);
						$id = $pdo->lastInsertId();
				}
				break;
			case 'export-images':
				$sql='SELECT name,title,description FROM images';
				$data=$pdo->query($sql)->fetchAll(PDO::FETCH_NUM);
				foreach($data as $key=>&$row) $row[2]=preg_replace('/\n+/','\n',$row[2]);
				array_unshift($data,['name','title','description']);
				header("Content-type: text/csv; charset=utf-8");
				header("Content-Disposition: attachment; filename=$action.csv");
				$csv=fopen('php://output', 'w');
				foreach($data as $row) fputcsv($csv, $row);
				fclose($csv);
				break;
			case 'export-blog':
				$sql='SELECT title,precis,article,created,updated FROM blog';
				$data=$pdo->query($sql)->fetchAll(PDO::FETCH_NUM);
				foreach($data as $key=>&$row) $row[2]=preg_replace('/\n+/','\n',$row[2]);
				array_unshift($data,['title','precis','article','created','updated']);
				header("Content-type: text/csv; charset=utf-8");
				header("Content-Disposition: attachment; filename=$action.csv");
				$csv=fopen('php://output', 'w');
				foreach($data as $row) fputcsv($csv, $row);
				fclose($csv);
				break;
			default:
		}

		back();
	}
?>
<?php
	$pagetitle='Australia Down Under: Database';
	$pagesubtitle='Setup Database';
#	require_once 'includes/head.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="icon" type="image/png" href="/favicon.png">
	<title>Australia Down Under<?php if(@$pagetitle) print " — $pagetitle";?></title>
	<link rel="stylesheet" type="text/css" href="/styles/styles.css">
	<link rel="stylesheet" type="text/css" href="/assets/setup/setup.css">
	<script type="text/javascript">
		document.addEventListener('DOMContentLoaded',init);
		function init() {
			var form=document.querySelector('form#init');
			form.elements['server'].onclick=function(event) {
				var passwords={
					'xampp': '',
					'mamp': 'root',
					'ampps': 'mysql',
					'wamp': '',
				};
				form.elements['password'].value=passwords[this.value]||'';
			}
		}
	</script>
</head>
<body>
<?php require_once 'header.php'; ?>
	<section>
<?php require_once('nav.php'); ?>
		<main>
<?php if(!$info): ?>
			<form id="init" method="get" action="">
				<p>
				<label for="info-server">Server</label>
				<select id="info-server" name="server" required>
					<option value="">Select One …</option>
					<option value="xampp">XAMPP</option>
					<option value="mamp">MAMP</option>
					<option value="ampps">AMPPS</option>
					<option value="wamp">WAMP</option>
				</select></p>
				<p><label for="info-database">Database</label>
				<select id="info-database" name="database" required>
					<option value="">Select One …</option>
					<option value="mysql">MySQL</option>
					<option value="sqlite">SQLite</option>
				</select></p>
				<p><label for="info-password">Root Password (MySQL Only)</label>
				<input id="info-password" type="text" name="password"></p>
				<button type="submit" name="action" value="info">Setup</button>
			</form>
<?php else: ?>
			<form id="setup" method="get" action="">
			<ul>
				<li>Database
					<ul><li><button type="submit" name="action" value="init">Reset Info</button></li></ul>
				</li>
				<li>Database
					<ul><li><button type="submit" name="action" value="australia">Create Database</button></li></ul>
				</li>
				<li>Images
					<ul><li><button type="submit" name="action" value="imagescreate">Create Images Table</button></li>
						<li><button type="submit" name="action" value="reset-images">Reset Images</button></li>
						<li><button type="submit" name="action" value="import-images">Import Image Data Only</button></li>
						<li><button type="submit" name="action" value="copy-images">Copy Images</button></li>
					</ul>
				</li>
				<li>Users
					<ul><li><button type="submit" name="action" value="users">Create Users</button></li>
						<li><button type="submit" name="action" value="user">Create Admin User</button>
							<div>
								<label><span>Given Name: </span><input type="text" name="givenname"></label>
								<label><span>Family Name: </span><input type="text" name="familyname"></label>
								<label><span>Email: </span><input type="email" name="email"></label>
								<label><span>Password: </span><input type="text" name="password"></label>
							</div>
						</li>
					</ul>
				</li>
				<li>Blog
					<ul><li><button type="submit" name="action" value="blogcreate">Create Blog Table</button></li>
						<li><button type="submit" name="action" value="import-blog">Import Blog</button></li>
					</ul>
				</li>
				<li>Export to CSV
					<ul><li><button type="submit" name="action" value="export-images">Export Images</button></li>
						<li><button type="submit" name="action" value="export-blog">Export Blog</button></li>
					</ul>
				</li>
			</ul>
			</form>
<?php endif; ?>
		</main>
		<!--div id="photo"><p>hohoho</p></div-->
	</section>
<?php require_once 'footer.php'; ?>
</body>
