/*	JavaScript
	================================================ */

	'use strict';

	window.onerror=function(message,url,line) {
		alert('Error: '+message+'\n'+url+': '+line);
	};

	//	Polyfills
		if(!Array.prototype.forEach) Array.prototype.forEach=function(callback,thisArg) {
			for(var i=0;i<this.length;i++) if(this[i]!==undefined) callback.call(thisArg,this[i],i,this);
		};
		if(!NodeList.prototype.forEach) NodeList.prototype.forEach=Array.prototype.forEach;


	//	Initialise
		document.addEventListener("DOMContentLoaded",init,false);
		function init() {
			var elements;
			if(elements=document.querySelectorAll('.preview-image')) elements.forEach(function(element) {doPreview(element); });
			var login;
			if(login=document.querySelector('form#login')) doShowPassword(login);
			var lightbox;
			if(lightbox=document.querySelector('ul.lb')) doLightbox(lightbox);
			if(lightbox=document.querySelector('table.manage')) doLightbox(lightbox);
			var sitemap;
			if(sitemap=document.querySelector('article#site-map')) doSiteMap();
		}

	//	Show Password
		function doShowPassword(form) {
			form['show'].onclick=showPassword;
			function showPassword(event) {
				form['password'].type='text';
				form['show'].setAttribute('on',true);
				window.setTimeout(function() {
					form['password'].type='password';
					form['show'].removeAttribute('on');
				},10000);
				event.preventDefault();
			}
		}
	//	Preview Uploaded Image
		function doPreview(element) {
			var reader = new FileReader();
			var fileInput=element.querySelector('input[type="file"]');
			var preview=element.querySelector('img');
			fileInput.onchange=function() {
				try {
					reader.onload=function(e) {
						preview.src=reader.result;
					};
					reader.readAsDataURL(this.files[0]);
				}
				catch (error) {
					preview.src='';
				}
				preview.alt=this.value;
				preview.title='New Thumbnail:\n'+this.value;
			};
		}

	//	Site Map
		function doSiteMap() {
			var map=document.querySelector('ul#map');
			var li=map.querySelectorAll('li');
			li.forEach(value=>{
				if(value.querySelector('ul')) {
					var span;
					if(span=value.querySelector('span:first-child')) span.remove();
					span=document.createElement('span');
					span.textContent='❯';
					value.insertAdjacentElement('afterbegin',span);
					value.classList.add('closed');
					span.onclick=function(event) {value.classList.toggle('closed')};
				}
			});
		}
