<?php

	/*	Library
		================================================ */

		function MimeType($filename) {
			$finfo = new finfo(FILEINFO_MIME_TYPE);
			return $finfo->file($filename);
		}


		function printr($data) {
			print '<pre>';
			print_r($data);
			print '</pre>';
		}

		function isImageType($type) {
			$types=['image/gif','image/jpeg',
				'image/pjpeg','image/png','image/x-png'];
			return in_array($type,$types);
		}

	/*	Library
		================================================ */

		function loadImage($fileName,$all=false) {
			$imageInfo=getimagesize($fileName);
			list($width,$height,$type)=$imageInfo;
			$mime=$imageInfo['mime'];
			switch ($mime) {
				case 'image/gif':
					$image=imagecreatefromgif($fileName);
					break;
				case 'image/jpeg':
					$image=imagecreatefromjpeg($fileName);
					break;
				case 'image/png':
					$image=imagecreatefrompng($fileName);
					break;
				default:
					$image=null;
			}

			if($all) return [$image,$width,$height,$type,$mime];
			else return $image;
		}
		function saveImage($image,$fileName,$mime='image/jpeg') {
			switch ($mime) {
				case 'image/gif':
					return imagegif($image,$fileName);
				case 'image/jpeg':
					return imagejpeg($image,$fileName);
				case 'image/png':
					return imagepng($image,$fileName);
				default:
					return false;
			}
		}
		function makeThumbnail($source,$destination,$size='160x120') {
			list($width,$height) = preg_split('/\s*x\s*/',$size);
			//	Load Image and get image data
				list($image,$sw,$sh,$type,$mime)=loadImage($source,true);

			//	Create an empty Thumbnail Image
				$thumbnail = imagecreatetruecolor($width,$height);

			//	Make padding adjustments
				$tx = $ty = 0;	// Top Left of Thumbnail; Change Later
				$sx = $sy = 0;	// Copy from the original top left
				$tw = $width; 	// Function parameters; change later
				$th = $height;
				//	$sw and $sh already determined previously

				$sourceShape=$sw/$sh;	//	from source
				$thumbShape=$tw/$th;	//	from thumbnail
				if($sourceShape<$thumbShape) {
					//	original is thinner
					$tw = $th * $sourceShape;
					$tx = ($width - $tw) /2;
				}
				elseif($sourceShape>$thumbShape) {
					//	original is wider
					$th = $tw / $sourceShape;
					$ty = ($height - $th) /2;
				}

			//	Copy the Original into the Smaller Image
				imagecopyresampled(
					$thumbnail,$image,	//	destination, source
					$tx,$ty,$sx,$sy,	//	top-left (origin)
					$tw,$th,$sw,$sh		//	width & height
				);

			//	Save image file
				saveImage($thumbnail,$destination,$mime);
		}
		function paging($page,$pages) {
			$links=[];
			$links[] = $page == 1 ? '<span>«</span>' :
				'<a href="?page=1">«</a>';
			$links[] = $page == 1 ? '<span>‹</span>' :
				sprintf('<a href="?page=%s">‹</a>',$page-1);
			$links[] = $page == $pages ? '<span>›</span>' :
				sprintf('<a href="?page=%s">›</a>',$page+1);
			$links[] = $page == $pages ? '<span>»</span>' :
				sprintf('<a href="?page=%s">»</a>',$pages);
			return implode('',$links);
		}

		function nl2p($string,$br=false) {
			if($br) {
				$string=preg_replace('/(\r?\n){2,}/','</p><p>',$string);
				$string=preg_replace('/\r?\n/','<br>',$string);
			}
			else $string=preg_replace('/\r?\n/','</p><p>',$string);
			return sprintf('<p>%s</p>',$string);
		}

		function normaliseLineBreak($text) {
		 	$text = str_replace("\r",'',$text);	  //	remove CR
			$text = str_replace('\n',"\n",$text); // convert '\n'
			return $text;
		}
