/**	Lightbox
	================================================
	Usage
	1	Wrap each smaller image inside an anchor:
		<a href="larger-image"><img …></a>
	2	If you want a title, include a title attribute:
		<a href="larger-image"><img … title="…"></a>
	3	In your startup script identify the container
		var container=document.querySelector('…');
	4	Call the doLightbox() function with your container
		doLightbox(container);

	Style
		There are some basic styles required to make
		it work. You can add your own custom styling
		in a separate style sheet.
	================================================ */

	function doLightbox(container) {
		var images=container.querySelectorAll('a');
		var a;	//	current image
		var currentItem=0;
		for(var i=0; i<images.length; i++) images[i].onclick=show.bind(images[i],i);

		//	Add Style Sheet & Rules
			var style = document.createElement('style');
				document.head.insertAdjacentElement('afterbegin',style);
				style.sheet.insertRule('div#lb { position: fixed; top: 50%; left: 50%; margin-right: -50%; transform: translate(-50%, -50%); z-index: 2; }');
				style.sheet.insertRule('div#lb-background { background-color: rgba(0,0,0,.5); position: fixed; top: 0; left: 0; width:100%; height: 100%;  z-index: 1; }');

		var div=document.createElement('div');
			div.id='lb';

		var img=document.createElement('img');
			div.appendChild(img);

		var p=document.createElement('p');
			div.appendChild(p);

		var background=document.createElement('div');
			background.id='lb-background';
			background.onclick=hide;
			document.body.appendChild(background);
			document.body.appendChild(div);
		hide();

		function load(a) {
			img.src=a.href;
			var title=a.querySelector('img').title;
			p.innerHTML=title;
			img.alt=title;
			img.title=title;

			img.onload=function() {
//				background.style.display=div.style.display='block';
				background.style.display='block';
				div.classList.add('show');
			};
		}

		function show(item,event) {
			a=this;
			load(a);
			currentItem=item;
			document.body.addEventListener('keydown',doKeys.bind(null,item));
			event.preventDefault();
		}
		function hide() {
			background.style.display='none';
			div.classList.remove('show');
			document.body.removeEventListener('keydown',doKeys);
		}

		function doKeys(item,event) {

//console.log(currentItem);
//console.log(item);
//console.log(event.key);
//			currentItem=item;
			switch(event.key) {
				case 'Esc':   	//  Old Version
				case 'Escape':
					hide();
					break;
				case 'Right':	//	Old Version
				case 'ArrowRight':
					currentItem++;
					if(currentItem>images.length) currentItem=0;
					a=images[currentItem];
//					a=images[currentItem]||images[0];
//					a=a.nextElementSibling||images[0];
					load(a);
					break;
				case 'Left':	//	Old Version
				case 'ArrowLeft':
					currentItem--;
					if(currentItem<0) currentItem=images.length-1;
					a=images[currentItem];
//					a=a.previousElementSibling||images[images.length-1];
					load(a);
					break;
				case 'Home':
				case 'ArrowUp':
				case 'Up':
					a=images[0];
					load(a);
					break;
				case 'End':
				case 'ArrowDown':
				case 'Down':
					a=a.previousElementSibling||images[images.length-1];
					load(a);
					break;
				default:

			}
			event.preventDefault();
		}
	}
