/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package serializationExample;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Can1 implements Serializable {
    int volume;
    int price;
    String name;
    
        public void saveCan(){
        //Save our datasource
        try (FileOutputStream fos = new FileOutputStream("can");
                ObjectOutputStream out = new ObjectOutputStream(fos);){
            out.writeObject(this);
        } catch (IOException ex) {
            System.out.println(ex);
        }
    }
    
    
    public Can1 loadCan(){
        try (FileInputStream fis = new FileInputStream("can")){
            ObjectInputStream in = new ObjectInputStream(fis);
            return (Can1) in.readObject();
        } catch (ClassNotFoundException | IOException ex) {
            System.out.println(ex);
            return null;
        } 
    }
    
    public String toString(){
        return "Name: "+name+" Volume: "+volume+" Price: "+price;
    }
}
