/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package DataSource;

import java.util.HashMap;
import java.util.Map;
import products.Eraser;
import products.Notepad;
import products.Pen;
import products.Pencil;
import products.PencilCase;
import products.WritingPack;
import salesApplication.PriceList;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class InMemoryDataSource implements DataSource {
    Map<String,PriceList> lists= new HashMap<>();
    
    public InMemoryDataSource(){
        //populate our data source with the default demo price list.
        lists.put("Demo",createDemoPriceList());
    }
    
    public void saveList(String name, PriceList priceList){
        //Put this price list into our data source.
        lists.put(name, priceList);
    }
    
    public PriceList retrieveList(String name){
        return lists.get(name);
    }
    
    public void getListNames(){
        System.out.println("Current Price List Available: "+lists.keySet());
    }

    private PriceList createDemoPriceList() {
        //Create an instance of pen
        Pen myPen = new Pen("Super Pen");
        myPen.type = Pen.PenType.FELTTIP;;
        myPen.enterDescription("This new pen is just amazing you need to try it!");
        myPen.setPrice(5.00);

        //Create an instance of Pencil
        Pencil myPencil = new Pencil("Custom Pencil");
        myPencil.enterDescription("This pencil is designed to stay sharp longer, and is comfortable in the hand.");
        myPencil.setPrice(2.00);

        //Create an instance of Notepad
        Notepad myNotepad = new Notepad("Student Special");
        myNotepad.enterDescription("240 leaf A4 lecture pad.");
        myNotepad.setPrice(3.50);

        //Create an instance of Eraser
        Eraser myEraser = new Eraser("New and Improved Eraser");
        myEraser.enterDescription("A long lasting smudgeless eraser for all kinds of pencils.");
        myEraser.setPrice(1.50);

        //Create an instance of PencilCase
        PencilCase myPencilCase = new PencilCase("Basic Pencil Case");
        myPencilCase.enterDescription("A small single zip plastic pencil case with lettering for names.");
        myPencilCase.setPrice(3.00);

        //Create and instance of WritingPack including 2x myPens, myEraser, myPencil and myPencilCase
        WritingPack myWritingPack = new WritingPack("Special Writing Pack");
        myWritingPack.pen1 = myPen;
        myWritingPack.pen2 = myPen;
        myWritingPack.pencil = myPencil;
        myWritingPack.eraser = myEraser;
        myWritingPack.pencilCase = myPencilCase;
        myWritingPack.enterDescription("WritingPack including two super pens, a custom pencil,"
                + " a new and improved eraser and a basic pencil case.");
        myWritingPack.setPrice(15.00);

        //create a price list with all these products in it and print it out
        PriceList demoPriceList = new PriceList();
        demoPriceList.addProduct(myPen);
        demoPriceList.addProduct(myPencil);
        demoPriceList.addProduct(myEraser);
        demoPriceList.addProduct(myPencilCase);
        demoPriceList.addProduct(myNotepad);
        demoPriceList.addProduct(myWritingPack);

        return demoPriceList;
    }
}
