Use Atlantic;
GO
IF EXISTS (SELECT * FROM sys.tables WHERE OBJECT_ID = OBJECT_ID(N'Orders') AND TYPE IN (N'U'))
DROP TABLE Orders;
GO
CREATE TABLE Orders
(
  orders_id INT NOT NULL
, customer_id	INT NOT NULL
, product_id INT NOT NULL
, destination_id INT NOT NULL
, orders_sell_price DECIMAL(6,2) NOT NULL CHECK (orders_sell_price > 0)
, orders_qty INT NOT NULL DEFAULT 1, CHECK (orders_qty > 0)
, orders_date DATE NOT NULL DEFAULT GETDATE()
, CONSTRAINT PK_Orders PRIMARY KEY CLUSTERED (orders_id)
);

USE Atlantic;
GO
SELECT *
FROM Orders;