Use Atlantic;
GO
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'usp_Insert_Into_Orders_Table') AND type = 'P')
DROP PROCEDURE dbo.usp_Insert_Into_Orders_Table;
GO
CREATE PROCEDURE usp_Insert_Into_Orders_Table @max_rows INT
AS
DECLARE @FromDate date = '2015-01-01'
DECLARE @ToDate date = GETDATE()
DECLARE @max_customer_ID INT
DECLARE @max_product_ID INT

SELECT @max_customer_ID = MAX(customer_ID)	
FROM Customer;
SELECT @max_product_ID = MAX(product_ID)
FROM Product;

INSERT INTO Orders
(
orders_ID
,	customer_ID
,	product_ID
,	destination_ID
,	orders_sell_price
,	orders_qty
,	orders_date
)
-- id_order; Row index
SELECT TOP (@max_rows) ROW_NUMBER() OVER (ORDER BY a.name) AS RowNumber
,
--id_customer
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,350)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(351,700)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(701,800)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(801,1000)
ELSE dbo.udf_RandBetween(1001,@max_customer_ID)
END
,
--id_product
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,250)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(251,400)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(401,700)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(701,850)
ELSE dbo.udf_RandBetween(851,@max_product_ID)
END
,
--id_destination
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,5)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(1,5)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(1,5)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(1,5)
ELSE dbo.udf_RandBetween(1,5)
END
,
1	-- orders_sell_price value placeholder until UPDATE
,
-- qty
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,25)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(26,40)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(41,70)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(71,85)
ELSE dbo.udf_RandBetween(86,100)
END
,
DATEADD(DAY, RAND(CHECKSUM(NEWID())) * (1 + DATEDIFF(DAY, @FromDate, @ToDate)), @FromDate)

FROM sys.all_objects AS a
CROSS JOIN sys.all_objects AS b;

