Use Atlantic;
GO

IF EXISTS (SELECT * FROM sys.tables WHERE OBJECT_ID = OBJECT_ID(N'Orders') AND TYPE IN (N'U'))
DROP TABLE Orders;
GO

CREATE TABLE Orders
(
  orders_id INT NOT NULL PRIMARY KEY
, customer_id	INT NOT NULL
, product_id INT NOT NULL
, destination_id INT NOT NULL
, orders_sell_price DECIMAL(6,2) NOT NULL  CHECK (orders_sell_price > 0)
, orders_qty INT NOT NULL DEFAULT 1, CHECK (orders_qty > 0)
, orders_date DATE NOT NULL DEFAULT GETDATE()
);
DECLARE @FromDate date = '2015-01-01'	
DECLARE @ToDate date = GETDATE()
DECLARE @max_customer_id INT
DECLARE @max_product_id INT

-- variables to hold the highest customer_id & highest product_id
-- When populating, these columns will not exceed these values
SELECT @max_customer_id = MAX(customer_id)	
FROM Customer
SELECT @max_product_id = MAX(product_id)
FROM Product;

INSERT INTO Orders
(
orders_id
,	customer_id
,	product_id
,	destination_id
,	orders_sell_price
,	orders_qty
,	orders_date
)
-- id_order; Row index
SELECT TOP 5000 ROW_NUMBER() OVER (ORDER BY a.name) AS RowNumber
,
--id_customer
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,350)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(351,700)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(701,800)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(801,1000)
ELSE dbo.udf_RandBetween(1001,@max_customer_ID)
END
,
--id_product
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,250)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(251,400)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(401,700)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(701,850)
ELSE dbo.udf_RandBetween(851,@max_product_ID)
END
,
--id_destination
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,5)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(1,5)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(1,5)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(1,5)
ELSE dbo.udf_RandBetween(1,5)
END
,
1	-- value placeholder until UPDATE
,
-- qty
CASE WHEN ROW_NUMBER() OVER (ORDER BY a.name)%3 = 1 THEN  dbo.udf_RandBetween(1,25)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%4 = 1 THEN dbo.udf_RandBetween(26,40)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%5 = 1 THEN dbo.udf_RandBetween(41,70)
WHEN ROW_NUMBER() OVER (ORDER BY a.name)%7 = 1 THEN dbo.udf_RandBetween(71,85)
ELSE dbo.udf_RandBetween(86,100)
END
,
DATEADD(DAY, RAND(CHECKSUM(NEWID())) * (1 + DATEDIFF(DAY, @FromDate, @ToDate)), @FromDate)

FROM sys.all_objects AS a
CROSS JOIN sys.all_objects AS b;
GO
SELECT *
FROM Orders