Use Atlantic;
GO
SELECT DATENAME(mm, Mth) AS 'TheMonth'
, Dy AS 'TheDay'
, (AO.orders_qty * AO.product_cost_price) AS line_total
, SUM(AO.orders_qty * AO.product_cost_price)
	 OVER(PARTITION BY Mth, Dy ORDER BY Mth, Dy ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS 'RunningTotalByRow'
, SUM(AO.orders_qty * AO.product_cost_price)
	 OVER(PARTITION BY Mth, Dy ORDER BY Mth, Dy RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW ) AS 'RunningTotalByRange'
FROM
	(
	SELECT MONTH(orders_date) AS Mth
	, DAY(orders_date) AS Dy
	, orders_qty
	, product_cost_price
	FROM v_Atlantic_Orders
	WHERE MONTH(orders_date) = 01
	)
	AS AO;