Use Atlantic;
GO
SELECT   O.customer_id AS cust_id
, O.orders_date
, O.orders_sell_price AS sell_price, O.orders_qty AS qty
, (O.orders_sell_price * O.orders_qty) AS line_total
, D.destination_name
, COUNT(*) OVER(PARTITION BY O.customer_id ORDER BY O.orders_id) AS nbr_orders
, SUM(orders_sell_price* orders_qty) OVER(PARTITION BY O.customer_id ORDER BY O.orders_id) AS running_total
FROM Customer AS C INNER JOIN Orders AS O
	ON C.customer_id = O.customer_id
	INNER JOIN Destination AS D
	ON O.destination_id = D.destination_id

SELECT   O.customer_id AS cust_id
, O.orders_date
, O.orders_sell_price AS sell_price, O.orders_qty AS qty
, (O.orders_sell_price * O.orders_qty) AS line_total
, D.destination_name
, COUNT(*) OVER(PARTITION BY O.customer_id, D.destination_name ORDER BY O.orders_id) AS nbr_orders
, SUM(orders_sell_price* orders_qty) OVER(PARTITION BY O.customer_id, D.destination_name ORDER BY O.orders_id) AS running_total
FROM Customer AS C INNER JOIN Orders AS O
	ON C.customer_id = O.customer_id
	INNER JOIN Destination AS D
	ON O.destination_id = D.destination_id
