Use Atlantic;
GO
DECLARE @nbr_rows INT
SELECT @nbr_rows = COUNT(customer_id)
FROM v_Atlantic_Orders;	-- must be terminated

WITH cte_orders (cust_id, nbr_orders, shipped_to)
AS
(
 SELECT 
	TOP (@nbr_rows) customer_id
,	COUNT(*) AS orders_placed
,	D.destination_name
FROM v_Atlantic_Orders AS AO INNER JOIN Destination AS D
	ON AO.destination_id = D.destination_id
GROUP BY AO.customer_id, D.destination_name
ORDER BY orders_placed DESC
 )
SELECT cust_id
, nbr_orders
, shipped_to
FROM cte_orders
WHERE nbr_orders > 1
ORDER BY nbr_orders DESC;