Use Atlantic;
GO
DECLARE @n INT
SELECT @n = COUNT(customer_id)
FROM v_Atlantic_Orders;

WITH cte_customer_sales	-- no input parameters
AS
 (
	SELECT	TOP (@n) customer_id 
,	COUNT(customer_id) AS nbr_orders
,	D.destination_name
	FROM v_Atlantic_Orders AS AO INNER JOIN Destination AS D
	ON AO.destination_id = D.destination_id
	GROUP BY customer_id, D.destination_name
	ORDER BY customer_id, D.destination_name
 )
SELECT customer_id AS cust_id
, nbr_orders
, destination_name
FROM  cte_customer_sales
WHERE nbr_orders > 1
ORDER BY nbr_orders DESC