----	NB You may have to change Component Settings - SQL Server; Properties; Log On - Local system Account
----	To allow advanced options to be changed.

--EXEC sp_configure 'show advanced options', 1;
--GO
---- To update the currently configured value for advanced options.
--RECONFIGURE;
--GO
---- To enable the feature.
--EXEC sp_configure 'xp_cmdshell', 1;
--GO
---- To update the currently configured value for this feature.
--RECONFIGURE;
--GO
USE master
DECLARE @name VARCHAR(50);		-- database name  
DECLARE @path VARCHAR(256);		-- path for backup files  
DECLARE @fileName VARCHAR(256);	-- filename for backup  
DECLARE @fileDate VARCHAR(20);	-- used for file name
SET NOCOUNT ON
SET @path = N'C:\Program Files\Microsoft SQL Server\MSSQL13.SQL_EXPRESS2016\MSSQL\Backup\'
SELECT @fileDate = CONVERT(VARCHAR(20),GETDATE(),112)
DECLARE db_cursor CURSOR FOR
SELECT name
FROM Master.dbo.sysdatabases
WHERE NOT name  IN ('master','model','msdb','tempdb','ReportServer$SQL_EXPRESS2016','ReportServer$SQL_EXPRESS2016TempDB')
OPEN db_cursor
	FETCH NEXT FROM db_cursor INTO @name
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @fileName = @path + @name
		-- + '_' + @fileDate
		+ '.bak'
		BACKUP DATABASE @name TO DISK = @fileName
		WITH NOFORMAT, INIT,  NAME = N'@filename-Full Database Backup', SKIP, NOREWIND, NOUNLOAD, STATS = 10
		FETCH NEXT FROM db_cursor INTO @name
	END
CLOSE db_cursor
DEALLOCATE db_cursor
