USE SQL_Course;
GO
CREATE VIEW v_CustomerTransactions
AS
SELECT C.cust_id
, O.order_num
, C.cust_name
, C.cust_city	
, OI.quantity
, OI.item_price
, OI.quantity * OI.item_price AS LineItem
, P.prod_id
, P.prod_name
, V.vend_name
, V.vend_address
FROM Customers AS C INNER JOIN Orders AS O
	ON C.cust_id = O.cust_id
	INNER JOIN OrderItems AS OI
	ON O.order_num = OI.order_num
	INNER JOIN Products as P
	ON OI.prod_id = P.prod_id
	INNER JOIN Vendors AS V
	ON P.vend_id = V.vend_id

--SELECT *
--FROM v_CustomerTransactions
