Use Atlantic;
GO
IF EXISTS (SELECT 1 FROM sys.views WHERE name = 'RandNbr' AND type = 'v')
DROP VIEW RandNbr
GO

CREATE VIEW dbo.RandNbr
AS
SELECT RAND() AS RandomNumber
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE name = 'udf_RandBetween')
DROP FUNCTION udf_RandBetween;
GO

CREATE FUNCTION dbo.udf_RandBetween(@Bottom integer, @Top integer)
RETURNS integer
AS
BEGIN
	Return (SELECT CAST(ROUND((@Top - @Bottom) * RandomNumber + @Bottom, 0) AS integer)
	FROM dbo.RandNbr)
END;
--Use Atlantic;
--GO
--SELECT dbo.udf_RandBetween(1, 100)