Use Atlantic;
GO
IF EXISTS (SELECT * FROM sys.views WHERE name = 'v_Atlantic_Orders' AND TYPE = 'V')
DROP VIEW v_Atlantic_Orders
GO
CREATE VIEW v_Atlantic_Orders
AS
SELECT C.customer_id
, C.cust_firstname + ' ' + C.cust_lastname AS cust_full_name
, C.cust_address
, C.cust_city
, O.orders_id
, O.orders_date
, P.product_id
, P.product_name
, O.orders_qty
, P.product_cost_price
, (O.orders_qty * P.product_cost_price) AS line_total
, D.destination_id
, D.destination_name

FROM Customer AS C INNER JOIN Orders AS O
	ON C.customer_id = O.customer_id
	INNER JOIN Product AS P
	ON O.product_id = P.product_id
	INNER JOIN Category AS CA
	ON P.category_id = CA.category_id
	INNER JOIN Destination AS D
	ON O.destination_id = D.destination_id;