Use Atlantic;
GO
SELECT 
CASE WHEN TRY_CAST(O.customer_id AS VARCHAR(20)) IS NULL   
    THEN COALESCE(CAST(O.customer_id as VARCHAR(20)), D.destination_name + ' '  + 'Subtotal')
    ELSE ''
	END AS Destination_Subtotal  
 --D.destination_name
, COUNT(*) AS nbr_orders
, SUM(O.orders_qty * O.orders_sell_price) AS total_sales
FROM Orders AS O INNER JOIN Destination AS D
	ON O.destination_id = D.destination_id
GROUP BY ROLLUP(D.destination_name, O.customer_id);

SELECT  D.destination_name AS Destination_Subtotal
, COUNT(*) AS nbr_orders
, SUM(O.orders_qty * O.orders_sell_price) AS total_sales
FROM Orders AS O INNER JOIN Destination AS D
	ON O.destination_id = D.destination_id
GROUP BY ROLLUP(D.destination_name)
ORDER BY nbr_orders;