Use Atlantic;
GO
SELECT customer_id
, (orders_qty * orders_sell_price) AS line_total
,	(SELECT CAST(AVG(O.orders_qty * O.orders_sell_price) AS DECIMAL(8,2))
	FROM Orders AS O) AS avg_table_total	
,	(orders_qty * orders_sell_price) -
		(SELECT CAST(AVG(orders_qty * orders_sell_price) AS DECIMAL(8,2))
		FROM Orders) AS variance
,  CASE WHEN
    (orders_qty * orders_sell_price) -
		(SELECT AVG(orders_qty * orders_sell_price)
		FROM Orders) > =0
	THEN 'Exceeded Average' 
    ELSE 'Below Average'
  END AS sale_status
FROM  Orders
ORDER BY customer_id