Use Utility;
GO
WITH
  cteReports (Employee_id, emp_first_name, emp_last_name, position,  mgr_id, dept_id)
  AS
  (
    SELECT emp_id, emp_First_Name, emp_Last_Name, position, mgr_id, dept_id	-- the anchor member
    FROM Employee_Hierarchy
    WHERE mgr_id IS NULL

    UNION ALL
    
	SELECT EH.emp_id, EH.emp_First_Name, EH.emp_Last_name, EH.position, EH.mgr_id, EH.dept_id -- the recursive member
    FROM Employee_Hierarchy  AS EH
      INNER JOIN cteReports AS R
        ON EH.mgr_id = R.Employee_id	-- the condition
  )
SELECT Employee_id AS emp_id
 , emp_first_name + ' ' + emp_last_name AS FullName, position
  ,  (SELECT position + ' - ' + emp_first_name + ' ' + emp_last_name + ' - ' + CONVERT(CHAR(20), cteReports.mgr_id)
	FROM Employee_Hierarchy
    WHERE emp_id = cteReports.mgr_id) AS ReportsTo
FROM cteReports 
ORDER BY emp_id