Use Atlantic;
GO
IF EXISTS
(SELECT *
	FROM sys.objects
	WHERE object_id = object_id(N'dbo.udf_Sentence_Case')	
		AND type IN(N'FN', N'TF', N'IF')
)
DROP FUNCTION dbo.udf_Sentence_Case
GO
CREATE FUNCTION dbo.udf_Sentence_Case(@string VARCHAR(255)) RETURNS VARCHAR(255)
AS
BEGIN
DECLARE @len_str INT					/*length of string*/
DECLARE @first_chr NCHAR(1)				/*first character of the string*/
DECLARE @remaining_chrs NVARCHAR(255)	/*starting at position 2, the remaining characters of the string*/
DECLARE @return_str NVARCHAR(255)		/*the converted string*/

	SELECT @len_str = LEN(@string)
	SELECT @first_chr = UPPER(LEFT(@string,1))
	SELECT @remaining_chrs = LOWER(SUBSTRING(@string, 2, @len_str -1))
	SELECT @return_str = @first_chr + @remaining_chrs

RETURN @return_str
END;