Use Atlantic;
GO
SELECT O.customer_id AS cust_id, O.orders_date
, O.orders_sell_price AS sell_price, O.orders_qty AS qty
, (O.orders_sell_price * O.orders_qty) AS line_total
, COUNT(*) OVER(PARTITION BY MONTH(O.orders_date) ORDER BY O.orders_date) AS nbr_orders
, SUM(O.orders_sell_price * O.orders_qty) OVER(PARTITION BY MONTH(O.orders_date) ORDER BY O.orders_date) AS running_total
FROM Orders AS O
WHERE O.orders_date BETWEEN  DATEFROMPARTS('2017','01','01') AND DATEFROMPARTS('2017','12','31')
ORDER BY MONTH(O.orders_date)