Use Atlantic;
GO
SELECT O.customer_id
,	CASE
		WHEN D.destination_name IS NULL 
		THEN 'Grand Total'
		WHEN O.customer_id IS NULL
		THEN D.destination_name + ' '+ 'Sub Total'
	ELSE D.destination_name
	END AS Destination_Subtotals
, COUNT(O.orders_qty) AS nbr_orders
, SUM(O.orders_qty * O.orders_sell_price) AS total_sales
FROM Orders AS O INNER JOIN Destination AS D
	ON O.destination_id = D.destination_id
GROUP BY ROLLUP(D.destination_name, O.customer_id)
