Use Atlantic;
GO
SELECT O.customer_id
, (O.orders_qty * O.orders_sell_price) AS line_total,
	(SELECT CAST(AVG(orders_qty * orders_sell_price) AS DECIMAL(8,2))
	FROM Orders
	WHERE customer_id = O.customer_id) AS avg_cust_total
,		(SELECT COUNT(customer_id)
		FROM Orders
		WHERE customer_id = O.customer_id) AS total_orders
,			(SELECT CAST(SUM(orders_qty * orders_sell_price) AS DECIMAL(8,2))
			FROM Orders
			WHERE customer_id = O.customer_id) AS total_value
FROM  Orders AS O
ORDER BY O.customer_id;