Use Atlantic;
GO
WITH cteYearlySales(sales_year, calc_price)
AS
(
	SELECT YEAR(orders_date)
	, CAST((orders_qty * product_cost_price) AS DECIMAL(12,2))
	FROM v_Atlantic_Orders
)
SELECT sales_year
, COUNT(sales_year) AS nbr_sales
, FORMAT(CONVERT(DECIMAL(12,2),SUM(calc_price)), 'C', 'un-us') AS total_sales
FROM cteYearlySales
GROUP BY sales_year
ORDER BY sales_year