Use Atlantic;
GO

IF (OBJECT_ID(N'[dbo].[trgAfterInsert]') IS NOT NULL)
BEGIN
      DROP TRIGGER [dbo].trgAfterInsert;
END;
GO
CREATE TRIGGER trgAfterInsert ON [dbo].[AtlanticEmployees] 
FOR INSERT
AS
	DECLARE @empid int;
	DECLARE @emp_Old_Name VARCHAR(100);
	DECLARE @emp_New_Name VARCHAR(100);
	DECLARE @emp_Old_Sal DECIMAL(10,2);
	DECLARE @emp_New_Sal DECIMAL(10,2);
	DECLARE @audit_action VARCHAR(100);
	DECLARE @HostName VARCHAR(100);
	DECLARE @UserName VARCHAR(100);

	SELECT @empid=i.emp_ID FROM inserted i;	
	SELECT @emp_New_Name=i.emp_Name FROM inserted i;	
	SELECT @emp_New_Sal=i.emp_Sal FROM inserted i;	
	SET @audit_action='Inserted Row -- After Insert Trigger.';
	SET @emp_Old_Name = 'New Employee'
	SET @emp_Old_Sal = 0
	SET @HostName = HOST_NAME()
	SET @UserName = SUSER_NAME()
	INSERT INTO dbo.AtlanticEmployeesAudit
           (emp_ID, emp_Old_Name, emp_New_Name, emp_Old_Sal, emp_New_Sal, 
				HostName, UserName, audit_Action, audit_Timestamp) 
	VALUES (@empid, @emp_Old_Name, @emp_New_Name, @emp_Old_Sal, @emp_New_Sal,
			@HostName, @UserName, @audit_action, GETDATE());

	PRINT 'AFTER INSERT trigger fired.'
--GO
--EXEC usp_Create_Insert_trigger
