Use Atlantic;
GO
IF (OBJECT_ID(N'[dbo].[trgAfterUpdate]') IS NOT NULL)
BEGIN
      DROP TRIGGER [dbo].trgAfterUpdate;
END;
GO
CREATE TRIGGER trgAfterUpdate ON [dbo].[AtlanticEmployees] 
FOR UPDATE
AS
	DECLARE @emp_id INT;
	DECLARE @emp_Old_Name VARCHAR(100);
	DECLARE @emp_New_Name VARCHAR(100);
	DECLARE @emp_Old_Sal DECIMAL(10,2);
	DECLARE @emp_New_Sal DECIMAL(10,2);
	DECLARE @audit_action VARCHAR(100);
	DECLARE @HostName	VARCHAR(100);
	DECLARE @UserName	VARCHAR(100);

	SELECT @emp_id=i.Emp_ID FROM inserted i;	
	SELECT @emp_Old_Name=i.Emp_Name FROM deleted i;
	SELECT @emp_New_Name=i.Emp_Name FROM inserted i;
	SELECT @emp_Old_Sal=i.Emp_Sal FROM deleted i;
	SELECT @emp_New_Sal=i.Emp_Sal FROM inserted i;
	
	IF UPDATE(emp_Name)
		SET @audit_action='Updated Row Name -- After Update Trigger.';
	IF UPDATE(emp_Sal)
		SET @audit_action='Updated Row Salary -- After Update Trigger.';
	SET @HostName = HOST_NAME()
	SET @UserName = SUSER_NAME()

	INSERT INTO dbo.AtlanticEmployeesAudit
	(Emp_ID, emp_Old_Name, emp_New_Name, 
	emp_Old_Sal,emp_New_Sal, HostName, UserName, Audit_Action, Audit_Timestamp) 

	SELECT i.emp_id, d.emp_Name, i.emp_Name, 
	d.emp_Sal, i.emp_Sal, @HostName, @UserName, @audit_action, GETDATE()
	FROM inserted AS i
	INNER JOIN Deleted AS d 
	ON i.emp_ID = d.emp_ID
--	VALUES(@emp_id, @emp_Old_Name, @emp_New_Name, @emp_Old_Sal, @emp_New_Sal, @audit_action, GETDATE());

	PRINT 'AFTER UPDATE Trigger fired.'
GO
