Use Atlantic;
GO

IF EXISTS 
(SELECT * FROM sys.objects
WHERE object_id = object_id(N'udf_SpendBoundary')
	AND type IN(N'FN', N'TF', N'IF')
)
DROP FUNCTION udf_SpendBoundary;
GO
CREATE FUNCTION udf_SpendBoundary(@Qty INT, @Low INT, @High INT)
RETURNS TABLE
AS
RETURN
(
SELECT O.customer_id
, O.orders_id
, SUM(O.orders_qty) AS total_qty
, SUM(O.orders_qty * O.orders_sell_price) AS total_sale
FROM Orders AS O
WHERE O.orders_qty <=  @Qty
GROUP BY O.customer_ID, O.orders_ID
,(O.orders_qty * O.orders_sell_price)
HAVING (O.orders_qty * O.orders_sell_price) > @Low
	AND (O.orders_qty * O.orders_sell_price) < @High
);

Use Atlantic;
GO
SELECT C.customer_id
, udf_SpendBoundary.orders_id
, udf_SpendBoundary.total_qty
, udf_SpendBoundary.total_sale
, C.cust_firstname + ' ' + C.cust_lastname AS full_name
, C.cust_city
FROM udf_SpendBoundary(2, 55, 100) INNER JOIN Customer AS C
	ON udf_SpendBoundary.customer_id = C.customer_ID
ORDER BY C.customer_id;