<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package Catch Themes
 * @subpackage Catch Everest
 * @since Catch Everest 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php 
/** 
 * catcheverest_before hook
 */
do_action( 'catcheverest_before' ); ?>

<div id="page" class="hfeed site">

	<?php 
    /** 
     * catcheverest_before_header hook
     */
    do_action( 'catcheverest_before_header' ); ?>
    
	<header id="masthead" role="banner">
    
    	<?php 
		/** 
		 * catcheverest_before_hgroup_wrap hook
		 */
		do_action( 'catcheverest_before_hgroup_wrap' ); ?>
        
    	<div id="hgroup-wrap" class="container">
        
       		<?php 
			/** 
			 * catcheverest_hgroup_wrap hook
			 *
			 * HOOKED_FUNCTION_NAME PRIORITY
			 *
			 * catcheverest_header_left 10
			 * catcheverest_header_right 15
			 */
			do_action( 'catcheverest_hgroup_wrap' ); ?>
            
        </div><!-- #hgroup-wrap -->
        
        <?php 
		/** 
		 * catcheverest_after_hgroup_wrap hook
		 *
		 * HOOKED_FUNCTION_NAME PRIORITY
		 *
		 * catcheverest_header_menu 10
		 */
		do_action( 'catcheverest_after_hgroup_wrap' ); ?>
        
	</header><!-- #masthead .site-header -->
    
	<?php 
    /** 
     * catcheverest_after_header hook
     */
    do_action( 'catcheverest_after_header' ); ?> 
        
	<?php 
    /** 
     * catcheverest_before_main hook
	 *
	 * HOOKED_FUNCTION_NAME PRIORITY
	 *
	 * catcheverest_slider_display 10
	 * catcheverest_homepage_headline 15
     */
    do_action( 'catcheverest_before_main' ); ?>
    
    
    <div id="main" class="container">
    
		<?php 
        /** 
         * catcheverest_main hook
         *
         * HOOKED_FUNCTION_NAME PRIORITY
         *
	 	 * catcheverest_homepage_featured_display 10
         */
        do_action( 'catcheverest_main' ); ?>